// Generated by CoffeeScript 1.10.0
(function() {
  var FindModeHistory, root;

  FindModeHistory = {
    storage: typeof chrome !== "undefined" && chrome !== null ? chrome.storage.local : void 0,
    key: "findModeRawQueryList",
    max: 50,
    rawQueryList: null,
    init: function() {
      this.isIncognitoMode = typeof chrome !== "undefined" && chrome !== null ? chrome.extension.inIncognitoContext : void 0;
      if (this.isIncognitoMode == null) {
        return;
      }
      if (!this.rawQueryList) {
        this.rawQueryList = [];
        if (this.isIncognitoMode) {
          this.key = "findModeRawQueryListIncognito";
        }
        this.storage.get(this.key, (function(_this) {
          return function(items) {
            if (!chrome.runtime.lastError) {
              if (items[_this.key]) {
                _this.rawQueryList = items[_this.key];
              }
              if (_this.isIncognitoMode && !items[_this.key]) {
                return _this.storage.get("findModeRawQueryList", function(items) {
                  if (!chrome.runtime.lastError) {
                    _this.rawQueryList = items.findModeRawQueryList;
                    return _this.storage.set({
                      findModeRawQueryListIncognito: _this.rawQueryList
                    });
                  }
                });
              }
            }
          };
        })(this));
      }
      return chrome.storage.onChanged.addListener((function(_this) {
        return function(changes, area) {
          if (changes[_this.key]) {
            return _this.rawQueryList = changes[_this.key].newValue;
          }
        };
      })(this));
    },
    getQuery: function(index) {
      if (index == null) {
        index = 0;
      }
      return this.rawQueryList[index] || "";
    },
    saveQuery: function(query) {
      var newSetting;
      if (0 < query.length) {
        this.rawQueryList = this.refreshRawQueryList(query, this.rawQueryList);
        newSetting = {};
        newSetting[this.key] = this.rawQueryList;
        this.storage.set(newSetting);
        if (!this.isIncognitoMode) {
          return this.storage.get("findModeRawQueryListIncognito", (function(_this) {
            return function(items) {
              if (!chrome.runtime.lastError && items.findModeRawQueryListIncognito) {
                return _this.storage.set({
                  findModeRawQueryListIncognito: _this.refreshRawQueryList(query, items.findModeRawQueryListIncognito)
                });
              }
            };
          })(this));
        }
      }
    },
    refreshRawQueryList: function(query, rawQueryList) {
      return ([query].concat(rawQueryList.filter((function(_this) {
        return function(q) {
          return q !== query;
        };
      })(this)))).slice(0, +this.max + 1 || 9e9);
    }
  };

  root = typeof exports !== "undefined" && exports !== null ? exports : window;

  root.FindModeHistory = FindModeHistory;

}).call(this);
